#pragma rtGlobals=1		// Use modern global access method.

Menu "Plot&Fit"
	submenu  "Miscellaneous"
		"Composites Panel",CompositesPnl()
	End
end
//equations found in
//B.B. Johnsen, A.J. Kinloch, R.D. Mohammed, A.C. Taylor and S. Sprenger, 
//Toughening mechanisms of nanoparticle-modified epoxy polymers. Polymer, 2007. 48(2): p. 530-541.


function WRC(R)//calculates witten rubenstein and colby modulus
	variable R
	variable G, a,E,c=1
	a= 120
	E=80	
	G=E*(a/R)^(3+C)	
	Return G
end

function volfractRod(wtpct,densityfiller)
  variable wtpct,densityfiller
  variable phi,densitymatrix=1.19//morthane,1.25//epoxy
  wtpct=.01*wtpct
  phi=(wtpct/densityfiller)/(((1-wtpct)/densitymatrix)+(wtpct/densityfiller))
  return phi
end

function volfractTube(wtpct)//matrix in core is considered part of the tube
	variable wtpct
  	variable T=236,Ri,Ro=950,densityfiller=2.1,diff,phi,densitymatrix=1.19//Morthane matrix
  	Ri=Ro-T
  	diff=(Ri^2)/(Ro^2-Ri^2)
  	wtpct=.01*wtpct
  	variable fillvol=(wtpct/densityfiller)*(1+diff)
  	variable matrixvol=((1-wtpct)/densitymatrix)-(wtpct*diff/densityfiller)
 	phi=fillvol/(fillvol+matrixvol)
  	return phi
end

  
function wtfractRod(volfract,densityfiller)
	variable volfract, densityfiller
	variable wtpct,densitymatrix=1.19
	wtpct=(volfract*densityfiller)/(((1-volfract)*densitymatrix)+(volfract*densityfiller))
	return wtpct*100
end




Function CompositesPNL()
	IN2G_CheckScreenSize("height",670)
	DoWindow CompositesPanel
	if(V_Flag)
		DoWindow/K CompositesPanel
	endif
	IR1D_InitDataManipulation()
	IR1P_InitializeGenGraph()
	If(!datafolderexists (" root:Packages:CompositesTool"))
		Newdatafolder root:Packages:CompositesTool
	endif	
	variable/g root:Packages:Compositestool:GraphLogY=0,root:Packages:Compositestool:GraphLogx=0
	variable/g root:Packages:CompositesTool:LNphiMax=.5236
	variable/g root:Packages:CompositesTool:Efiller=70
	variable/g root:Packages:CompositesTool:LNKe=2.5
	Variable /g root:Packages:CompositesTool:Ematrix=2.8237
	Variable /g root:Packages:CompsitesTool:CompositesErrors=0
	Variable /g root:Packages:CompositesTool:LNbeta=0
	NVAR Efiller=root:Packages:CompositesTool:Efiller
	NVAR LNke=root:Packages:CompositesTool:LNKe
	NVAR Ematrix=root:Packages:CompositesTool:Ematrix
	NVAR LNbeta=root:Packages:CompositesTool:LNbeta
	LNbeta=((efiller/ematrix)-1)/((efiller/ematrix)+LNke-1)
	make/o/N=2 xavedata,yavedata
	xavedata={ .02, .15}
	yavedata={ 1, .01}
	CompositesPlot("yavedata","xavedata", "")
	setAxis bottom .02, .1
	SetAxis/A left
	removefromgraph yavedata
	textBox/K/N=text0
end

Function CompositesPlot(rwavename,qwavename, text)
	string rwavename,qwavename, text
	wave rwave=$rwavename
	wave qwave=$qwavename			
	dowindow/K CompositesPanel
	Display/K=1/N=CompositesPanel/W=(1*IN2G_ScreenWidthHeight("width"),1*IN2G_ScreenWidthHeight("heigth"),30*IN2G_ScreenWidthHeight("width"),60*IN2G_ScreenWidthHeight("height")) rwave vs qwave
	ControlBar /T 210
	TitleBox  title anchor= MT,  fColor=(0,0,65534 ), font="Arial", fsize=18, fstyle=0, Title="Composites Tool",Labelback=0, POS={150,1},Size={400,18}
	variable YPOS=3
	CheckBox Compositeserrors pos={70,YPOS},title="Errors?", variable= root:Packages:CompositesTool:Compositeserrors
	CheckBox GraphLogx pos={135,YPOS},title="LogX", variable= root:Packages:Compositestool:GraphLogx, proc=DWS_GenPlotCheckBox
	CheckBox GraphLogY pos={175,YPOS},title="LogY", variable= root:Packages:Compositestool:GraphLogY, proc=DWS_GenPlotCheckBox
	
	YPOS=130
	//Button PlotModulusData,pos={0,YPOS},size={40,16},font="Times New Roman",fSize=10,proc=CompositesButtonProc,title="Plot"		
		
	Button PlotModulus,pos={0,YPOS},size={70,16},font="Times New Roman",fSize=10,proc=CompositesButtonProc,title="PlotModulus"	
	Button RemoveCompositesTrace,pos={75,YPOS},size={50,16},font="Times New Roman",fSize=10,proc=CompositesButtonProc,title="Remove"		

	Button LewisNielsen,pos={130,YPOS},size={65,16},font="Times New Roman",fSize=10,proc=CompositesButtonProc,title="Lewis-Nielsen"		
	Button Smallwood,pos={200,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=CompositesButtonProc,title="Smallwood"		
	YPOS=150
	SetVariable Efiller, pos={2,YPOS}, size={80,20},title="Efiller",limits={0,inf,.01 },value= root:Packages:compositestool:Efiller
	SetVariable LNphiMax, pos={90,YPOS}, size={85,20},title="Phimax", limits={0,inf,.01 },value= root:Packages:compositestool:LNphiMax		
	SetVariable LNKe, pos={180,YPOS}, size={65,20},title="Ke", limits={0,inf,.01 },value= root:Packages:compositestool:LNKe	
	SetVariable Ematrix, pos={250,YPOS}, size={87,20},title="Ematrix", limits={0,inf,.01 },value= root:Packages:compositestool:Ematrix	
	
	YPOS=168
		valdisplay LNBeta, pos={2,YPOS}, size={60,20},title="beta",  value= #"root:Packages:CompositesTool:LNbeta" 
//	valdisplay ALVR, pos={100,YPOS}, size={70,20},title="R"	,format="%.1f nm", value=#" root:Packages:ALVTool:ALVRh"
	String PckgDataFolder="CompositesTool"
	String PanelWindowName="CompositesPanel"
	String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
	String AllowedResultsTypes=""//"SizesNumberDistribution;SizesVolumeDistribution;"
	String AllowedUserTypes=""//"*_par;" or "r*;"	
	String UserNameString=""//"_par" or "qrs"
	String XUserTypeLookup=""//"r*:q*;"	
	String EUserTypeLookup=""//"s*;"
	variable RequireErrorWaves=0
	variable  AllowModelData=0	
	IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)	
	MoveSelectionTools(2, 2)
end


Function CompositesButtonProc(ctrlName) : ButtonControl
	String ctrlName
	SVAR ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating		
	SVAR FolderName=root:Packages:CompositesTool:DataFolderName
	SVAR RWaveName=root:Packages:CompositesTool:IntensityWaveName
	SVAR QWaveName=root:Packages:CompositesTool:QWavename		
	SVAR SWaveName=root:Packages:CompositesTool:ErrorWaveName	
	NVAR Efiller=root:Packages:CompositesTool:Efiller
	NVAR LNphiMax=root:Packages:CompositesTool:LNphiMax
	NVAR LNKe=root:Packages:CompositesTool:LNKe
	NVAR Ematrix=root:Packages:CompositesTool:Ematrix
	NVAR CompositesErrors=root:Packages:CompositesTool:compositeserrors
	NVAR GraphLogY=Root:Packages:Compositestool:GraphLogY
	NVAR GraphlogX=root:Packages:Compositestool:GraphLogx
	NVAR LNbeta=root:Packages:CompositesTool:LNbeta
	
	string wavenote, cmd,checked,csra,csrb,fitwavename,tracelist,Nstr,list,tracename
	variable N, items
	if (datafolderexists(foldername))
		setdatafolder foldername
		wave RWave=$Rwavename	
		wave QWave=$Qwavename	
		wave SWave=$Swavename
		wave w_coef
	endif

IF(cmpstr(ctrlName,"Plotmodulus")==0)	
		setdatafolder  FolderName	; AbortOnRTE
		Appendtograph RWave vs qwave
		//start=LocateValue(Rwavename, .9,1,2)
		N=(LocateValue(Rwavename, 0,3,0))-1
		If (2==numtype(N))
			N=numpnts(Rwave)
		endif
		Nstr=num2str(N)
		execute("cursor b,"+RWaveName+","+Nstr)
		execute("cursor a,"+RWaveName+","+"1")
		If (WaveExists(yavedata))
			Removefromgraph yavedata
		endif
		Legend/C/N=text1
	 	setaxis/A
			Label Left "\Z16\f01\F'Arial'Modulus (GPa)"
			Label bottom "\Z18Volume Fraction"
			TextBox/K/N=FolderLegend		
		ModifyGraph log(left)=graphlogy
		ModifyGraph log(bottom)=graphlogx
		ModifyGraph tick=2		
			tracelist=TraceNameList("CompositesPanel", ";", 1 )
			items=ItemsInList(tracelist )
			items=items-1
			tracename=StringFromList(items, tracelist )
			ModifyGraph mode($tracename)=3,marker($tracename)=8,msize($tracename)=2
			If (Compositeserrors)
				ErrorBars $Rwavename Y,wave=(swave,swave)
			endif
	endif
	
	IF(cmpstr(ctrlName,"RemoveCompositesTrace")==0)
		tracelist=TraceNameList("CompositesPanel", ";", 1 )
		tracename=StringFromList(0, tracelist,";")
		If (!stringmatch(tracename, "" ))
			tracename=StringFromList(1, tracelist,";")
			RemoveFromGraph $tracename
		else
			Legend/K/N=text1
			string boxname="CF_"+Rwavename
			TextBox/K/N=$boxname
		endif	
	endif
	variable maxphi=qwave(numpnts(qwave))
	string thenote
	IF(cmpstr(ctrlName,"LewisNielsen")==0)
		N=numpnts(qwave)
		maxphi=qwave(numpnts(qwave))
		make/o LewisNielsen
		SetScale/I x 0,maxphi,"", LewisNielsen
		Duplicate/o LewisNielsen, muwave		
		LNbeta=((efiller/ematrix)-1)/((efiller/ematrix)+LNke-1)	
		muwave=1+((1-x)/LNphimax)*(x*LNphimax+(1-LNphimax)*(1-x))		
		LewisNielsen=Ematrix*((1+(LNke-1)*LNbeta*x)/(1-LNbeta*muwave*x))
		appendtograph LewisNielsen
		killwaves muwave
		thenote ="Ke="+num2str(LNke)+";Ematrix="+num2str(Ematrix)+";Efiller="+num2str(Efiller)+";beta="+num2str(LNbeta)
		Note  LewisNielsen thenote
	endif
	
	IF(cmpstr(ctrlName,"Smallwood")==0)
		N=numpnts(qwave)
		make/o Smallwood
		SetScale/I x 0,maxphi,"", Smallwood
		Smallwood=Ematrix*(1+LNke*x)
		appendtograph Smallwood
		thenote ="Ke="+num2str(LNke)+";Ematrix="+num2str(Ematrix)+";Efiller="+num2str(Efiller)
		Note  Smallwood thenote
	endif
end
